/** !------------------------------------------------------------------------->
*
*  @file Rte_generated.h
*
*  @creationDate 21 February 2025 14:00:51
*
*  @brief Generated Rte configuration header file.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2025, dSPACE GmbH. All rights reserved.
*
*  @version
*
*   <hr><br>
*!-------------------------------------------------------------------------->*/

/* File ID: f8d6e1ef-f9f4-4ed6-a9ad-a7c56433791a */
#pragma once

#include "../Config.h"
#include "../../BusConfiguration.h"
#include "../Com/Com_generated.h"
#include <Std_Types.h>

/* Signal ID, uint16 does not match with TLSR callback. */
typedef Com_SignalIdType Rte_SignalIdType;

#define RTE_NO_SUCH_SIGNAL 0x75

/*------------------------------------------------------------------------------------------------*\
  GENERATED RTE SIGNAL IDs
  RTE Signal Ids are identical to COM SignalIds for performance reasons
\*------------------------------------------------------------------------------------------------*/

/* RTE Signal definitions for the RTE module. */
#define Rte_X_Inst_0_Torque_Compressor_10834_10561_10897 Com_X_Inst_0_Torque_Compressor_10834_10561_10897
#define Rte_X_Inst_0_EPower_Compressor_10835_10561_10897 Com_X_Inst_0_EPower_Compressor_10835_10561_10897
#define Rte_X_Inst_0_AngVel_Compressor_10836_10561_10897 Com_X_Inst_0_AngVel_Compressor_10836_10561_10897
#define Rte_X_Inst_4_T_battery4_10816_10561_10897 Com_X_Inst_4_T_battery4_10816_10561_10897
#define Rte_X_Inst_4_T_battery3_10817_10561_10897 Com_X_Inst_4_T_battery3_10817_10561_10897
#define Rte_X_Inst_4_T_battery2_10818_10561_10897 Com_X_Inst_4_T_battery2_10818_10561_10897
#define Rte_X_Inst_4_T_battery1_10819_10561_10897 Com_X_Inst_4_T_battery1_10819_10561_10897
#define Rte_X_Inst_5_T_motor_10812_10561_10897 Com_X_Inst_5_T_motor_10812_10561_10897
#define Rte_X_Inst_5_T_inverter_10813_10561_10897 Com_X_Inst_5_T_inverter_10813_10561_10897
#define Rte_X_Inst_5_T_coolant_inverter_out_10814_10561_10897 Com_X_Inst_5_T_coolant_inverter_out_10814_10561_10897
#define Rte_X_Inst_5_T_coolant_battery_in_10815_10561_10897 Com_X_Inst_5_T_coolant_battery_in_10815_10561_10897
#define Rte_X_Inst_6_PJoule_battery_10808_10561_10897 Com_X_Inst_6_PJoule_battery_10808_10561_10897
#define Rte_X_Inst_6_p_cond_10809_10561_10897 Com_X_Inst_6_p_cond_10809_10561_10897
#define Rte_X_Inst_6_p_chiller_10810_10561_10897 Com_X_Inst_6_p_chiller_10810_10561_10897
#define Rte_X_Inst_6_i_battery_10811_10561_10897 Com_X_Inst_6_i_battery_10811_10561_10897
#define Rte_X_Inst_1_cmd_rad_bypass_10826_10561_10897 Com_X_Inst_1_cmd_rad_bypass_10826_10561_10897
#define Rte_X_Inst_1_cmd_parallel_serial_10827_10561_10897 Com_X_Inst_1_cmd_parallel_serial_10827_10561_10897
#define Rte_X_Inst_1_cmd_motor_pump_10828_10561_10897 Com_X_Inst_1_cmd_motor_pump_10828_10561_10897
#define Rte_X_Inst_1_cmd_heater_10829_10561_10897 Com_X_Inst_1_cmd_heater_10829_10561_10897
#define Rte_X_Inst_1_cmd_fan_10830_10561_10897 Com_X_Inst_1_cmd_fan_10830_10561_10897
#define Rte_X_Inst_1_cmd_comp_10831_10561_10897 Com_X_Inst_1_cmd_comp_10831_10561_10897
#define Rte_X_Inst_1_cmd_chiller_bypass_10832_10561_10897 Com_X_Inst_1_cmd_chiller_bypass_10832_10561_10897
#define Rte_X_Inst_1_cmd_battery_pump_10833_10561_10897 Com_X_Inst_1_cmd_battery_pump_10833_10561_10897
#define Rte_X_Inst_2_Q_motor_10822_10561_10897 Com_X_Inst_2_Q_motor_10822_10561_10897
#define Rte_X_Inst_2_Q_inverter_10823_10561_10897 Com_X_Inst_2_Q_inverter_10823_10561_10897
#define Rte_X_Inst_2_Q_dcdc_10824_10561_10897 Com_X_Inst_2_Q_dcdc_10824_10561_10897
#define Rte_X_Inst_2_Q_charger_10825_10561_10897 Com_X_Inst_2_Q_charger_10825_10561_10897
#define Rte_X_Inst_3_v_vehicle_10820_10561_10897 Com_X_Inst_3_v_vehicle_10820_10561_10897
#define Rte_X_Inst_3_I_traction_10821_10561_10897 Com_X_Inst_3_I_traction_10821_10561_10897

/* extern declarations of COM signal variables */
extern uint16 Com_TX_Inst_0_Torque_Compressor_10834_10561_10897_sgn_val;
extern uint16 Com_TX_Inst_0_EPower_Compressor_10835_10561_10897_sgn_val;
extern uint16 Com_TX_Inst_0_AngVel_Compressor_10836_10561_10897_sgn_val;

extern uint16 Com_TX_Inst_4_T_battery4_10816_10561_10897_sgn_val;
extern uint16 Com_TX_Inst_4_T_battery3_10817_10561_10897_sgn_val;
extern uint16 Com_TX_Inst_4_T_battery2_10818_10561_10897_sgn_val;
extern uint16 Com_TX_Inst_4_T_battery1_10819_10561_10897_sgn_val;

extern uint16 Com_TX_Inst_5_T_motor_10812_10561_10897_sgn_val;
extern uint16 Com_TX_Inst_5_T_inverter_10813_10561_10897_sgn_val;
extern uint16 Com_TX_Inst_5_T_coolant_inverter_out_10814_10561_10897_sgn_val;
extern uint16 Com_TX_Inst_5_T_coolant_battery_in_10815_10561_10897_sgn_val;

extern uint16 Com_TX_Inst_6_PJoule_battery_10808_10561_10897_sgn_val;
extern uint8 Com_TX_Inst_6_p_cond_10809_10561_10897_sgn_val;
extern uint8 Com_TX_Inst_6_p_chiller_10810_10561_10897_sgn_val;
extern sint16 Com_TX_Inst_6_i_battery_10811_10561_10897_sgn_val;


extern uint8 Com_RX_Inst_1_cmd_rad_bypass_10826_10561_10897_sgn_val;
extern uint8 Com_RX_Inst_1_cmd_parallel_serial_10827_10561_10897_sgn_val;
extern uint8 Com_RX_Inst_1_cmd_motor_pump_10828_10561_10897_sgn_val;
extern uint8 Com_RX_Inst_1_cmd_heater_10829_10561_10897_sgn_val;
extern uint8 Com_RX_Inst_1_cmd_fan_10830_10561_10897_sgn_val;
extern uint16 Com_RX_Inst_1_cmd_comp_10831_10561_10897_sgn_val;
extern uint8 Com_RX_Inst_1_cmd_chiller_bypass_10832_10561_10897_sgn_val;
extern uint8 Com_RX_Inst_1_cmd_battery_pump_10833_10561_10897_sgn_val;

extern uint16 Com_RX_Inst_2_Q_motor_10822_10561_10897_sgn_val;
extern uint16 Com_RX_Inst_2_Q_inverter_10823_10561_10897_sgn_val;
extern uint16 Com_RX_Inst_2_Q_dcdc_10824_10561_10897_sgn_val;
extern uint16 Com_RX_Inst_2_Q_charger_10825_10561_10897_sgn_val;

extern uint16 Com_RX_Inst_3_v_vehicle_10820_10561_10897_sgn_val;
extern sint16 Com_RX_Inst_3_I_traction_10821_10561_10897_sgn_val;



#define SCALE_IDENTICAL(TARGET_TYPE,TARGET,SOURCE_TYPE,SOURCE,ROUND_SUFFIX) double tmp_val = (*((SOURCE_TYPE*) SOURCE)); \
if (ROUND_SUFFIX && tmp_val > 0) *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) (tmp_val + 0.5); else if (ROUND_SUFFIX && tmp_val < 0)  *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) (tmp_val - 0.5); \
else *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) tmp_val;

#define SCALE_LINEAR(TARGET_TYPE,TARGET,SOURCE_TYPE,SOURCE,N0,N1,D0,ROUND_SUFFIX) double tmp_val = (((( *((SOURCE_TYPE*) SOURCE) ) * N1) + N0) / ((double) D0) ); \
if (ROUND_SUFFIX && tmp_val > 0) *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) (tmp_val + 0.5); else if (ROUND_SUFFIX && tmp_val < 0)  *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) (tmp_val - 0.5); \
else *((TARGET_TYPE*) TARGET) = (TARGET_TYPE) tmp_val;

/*------------------------------------------------------------------------------------------------*\
  FUNCTION PROTOTYPES
\*------------------------------------------------------------------------------------------------*/

#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_SetCodedValue
 ***
 *** DESCRIPTION:
 ***     Calculates a new coded value, if the physical value has changed.
 ***
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     boolean           always         Flag which enforces calculation even if the physical signal did not change.
 ***
 *** RETURNS:
 ***     boolean  Flag which inidcates that a calculation was performed and the underlying
 ***              PDU has to be updated.
 \**************************************************************************************************/
 boolean Rte_SetCodedValue(Rte_SignalIdType SignalId, boolean always);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_SetPhysicalValue
 ***
 *** DESCRIPTION:
 ***     Calculates a new physical value, if the coded value has changed.
 ***
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     boolean           always         Flag which enforces calculation even if the coded signal did not change.
 ***                                      This behavior is used for initialization during startup
 ***
\**************************************************************************************************/
void Rte_SetPhysicalValue(Rte_SignalIdType SignalId, boolean always);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_WriteSignal
 ***
 *** DESCRIPTION:
 ***     Updates the signal object identified by SignalId with the signal referenced by the
 ***     SignalDataPtr.
 ***
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     const void *      SignalDataPtr  Reference to the signal data to store the received data
 ***                                      in.
 ***
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
uint8 Rte_WriteSignal(
    Rte_SignalIdType SignalId,
    const void * SignalDataPtr);


/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_ReadSignal
 ***
 *** DESCRIPTION:
 ***     The function copies the content of the associated shadow buffer to the given memory location
 ***     and performs signal conversion.
 ***
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be read.
 ***     void *            SignalDataPtr  Reference to the signal data to store the received data
 ***                                      in.
 ***
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
uint8 Rte_ReadSignal(
        Rte_SignalIdType SignalId,
        void * SignalDataPtr);





#ifdef __cplusplus
}
#endif /* __cplusplus */


